from diffusers import StableDiffusionPipeline
import torch
import argparse
from torchvision.utils import make_grid, save_image
from torchvision.transforms import Compose, ToTensor
import numpy as np

parser = argparse.ArgumentParser()
parser.add_argument('--steps', '-t', type=int, help='steps')
parser.add_argument('--scale', '-s', type=float, help='scale')
parser.add_argument('--model', '-m', type=str, help='model path')
parser.add_argument('--promt', '-p', type=str, help='promt')
parser.add_argument('--out_dir', '-o', type=str, help='output directory')
args = parser.parse_args()

model_id = args.model
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to("cuda")

prompt = args.promt
images = pipe(prompt, num_inference_steps=args.steps, guidance_scale=args.scale, num_images_per_prompt=8).images
for i, image in enumerate(images):
    image.save(f"{args.out_dir}/{args.promt}_{i}.png")
# images = torch.stack()
# grid = make_grid(images)
# save_image(grid, f"{args.out_dir}/{args.promt}.png")
